<%@ Page Title="TBI Instruments - Patients Instruments" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="PatientInstrumentsMain.aspx.cs" Inherits="PatientInstrumentsMain" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">

    <style type="text/css">
            .breadcrumbInstrument {
                background-color:#6B1424;
                border-bottom:1px solid #000;
                color:#FFF;
                font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
                font-variant:small-caps;
                font-weight:700;
                letter-spacing:1px;
                margin: 2px 0 2px 0;
                padding:8px 25px 5px 10px;
            }
    </style>
        
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ValidationSummary ID="ValidationSummaryPatientInstruments"  runat="server"
        ValidationGroup="OnSave"
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="True" />
    <asp:Panel ID="PanelPatientConfirm" runat="server">
    <div id="skiplink">
        <a href="#content">skip to page content</a>
    </div>
        <asp:Menu 
                        ID="Menu2" 
                        runat="server" 
                        SkipLinkText="Skip Left Navigation Links"
                        DynamicHorizontalOffset="2"  Width="166px" 
                        StaticMenuItemStyle-CssClass = "leftMenuItem"  
                        DynamicMenuItemStyle-CssClass = "leftMenuItem"  
                        StaticDisplayLevels="3" Height="134px" 
                        onmenuitemclick="Menu2_MenuItemClick" >
                        <StaticHoverStyle CssClass= "leftMenuItemHover" />
                        <DynamicHoverStyle CssClass= "leftMenuItemHover" />
                    </asp:Menu>
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Confirm Patient and Select Instrument"></asp:Label> 
        </div>
        <br />
        <table  cellpadding="3" cellspacing="3" border="0" width="100%">
            <tr>
                <td>
                    <asp:Panel ID="PanelPatient" 
                          GroupingText="Patient&nbsp;&nbsp;" runat="server">
                    <br />
                    &nbsp;&nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel"></asp:Label><br />
                    <br />
                    </asp:Panel>
                </td>
            </tr>
            <tr>
                <td>
                   <br />
                   <br />
                   To begin, verify that the patient name above is correct and enter the patient's SSN to confirm the correct patient is selected.
                </td>
            </tr>
            <tr>
                <td>
                   <asp:Label ID="LabelforTextBoxSSNConfirm" runat="server" 
                        AssociatedControlID="TextBoxSSNConfirm" SkinID="DataLabel">
                         Confirm Patient SSN(###-##-####) *:
                    </asp:Label>
                    <br />
                    <asp:TextBox ID="TextBoxSSNConfirm" runat="server"/>
                    <asp:RegularExpressionValidator ID = "RegularExpressionValidatorTextBoxSSN"
                            ControlToValidate = "TextBoxSSNConfirm" 
                            Display = "Static" 
                            runat = "server" 
                            EnableClientScript="true"
                            ErrorMessage = "SSN needs to be in the following format (dashes optional): XXX-XX-XXXX.  Include a 'P' or 'p' at the end for pseudo SSNs."
                            SetFocusOnError = "true" ValidationExpression = "^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$">
                    </asp:RegularExpressionValidator>    
                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorSSN"
                            ControlToValidate="TextBoxSSNConfirm"
                            Display="Static"
                            runat="server"
                            EnableClientScript="true"
                            ErrorMessage = "SSN is required."
                            SetFocusOnError="true">
                        </asp:RequiredFieldValidator>  
                    <asp:Label ID = "LabelWarningNotificationMessage" runat = "server" 
                        SkinID="DataLabel"
                        Visible="false"
                        Text="">
                    </asp:Label>     
                </td>
            </tr>
            <tr>
                <td>
                    <br />
                </td>
            </tr>
        </table>                 
    </asp:Panel>
    <asp:Panel ID="PanelInstrumentList" runat="server" Visible="true">
        <table cellpadding="7" cellspacing="3" border="0" width="100%" >
            <tr>
                <td align="left">
                   <%--<asp:LinkButton ID="HyperLinkViewLastThreeInstruments" runat="server" Text="View Last Three Instruments" Font-Bold="true" ForeColor="Black"
                        OnClick="Button_ViewLastThreeInstruments" CausesValidation="False" >
                    </asp:LinkButton>
                   <%-- 
                     <asp:HyperLink ID="HyperLinkViewLastThreeInstruments" runat="server" NavigateUrl="~/TBI_Instruments/InstrumentLastThree.aspx" Target="_blank"
                                   Text="View Last Three Instruments" Font-Bold="true" ForeColor="Black">
                    </asp:HyperLink>
                    --%> 

                    <asp:Button ID="ViewLastThreeInstruments" runat="server"
                                        Text="View Last Three Instruments"  
                                        ToolTip="Select" 
                                        CommandName="SELECT" 
                                        OnClick="Button_ViewLastThreeInstruments"
                                        OnClientClick="javascript:if(Page_ClientValidate())return aspnetForm.target ='_blank';" 
                                        CausesValidation="false"
                        Visible="false" />
                </td>
            </tr>
            <tr>
                <td align="left">
                    <%--<asp:LinkButton ID="HyperLinkViewAllInstruments" runat="server" Text="View All Instruments" Font-Bold="true" ForeColor="Black"
                        OnClick="Button_ViewLastAllInstruments" CausesValidation="False">
                    </asp:LinkButton>
                    <asp:HyperLink ID="HyperLinkViewAllInstruments" runat="server" NavigateUrl="~/TBI_Instruments/InstrumentLastAll.aspx" Target="_blank"
                                   Text="View All Instruments" Font-Bold="true" ForeColor="Black">
                    </asp:HyperLink>--%>
                    <asp:Button ID="ViewAllInstruments" runat="server"
                                        Text="View All Instruments"  
                                        ToolTip="Select" 
                                        CommandName="SELECT" 
                                        OnClick="Button_ViewLastAllInstruments"
                                        OnClientClick="javascript:if(Page_ClientValidate())return aspnetForm.target ='_blank';" 
                                        CausesValidation="false" Visible="false" />
                </td>
            </tr>
         </table>


        <table  cellpadding="3" cellspacing="3" border="0" width="100%" >
            <tr>
                <td>
                    <asp:GridView ID = "GridViewInstruments" 
                        ShowFooter = "False" 
                        DataKeyNames="Id"
                        AutoGenerateColumns = "False" 
                        runat ="server"   
                        OnRowCommand="GridViewInstruments_RowCommand" 
                        Caption="Select the Instrument that you want to submit:" CaptionAlign="Left"
                        AllowPaging="false"
                        Width="500px">
                        <Columns>
                            <asp:TemplateField HeaderText = "Instrument Name">
                                <ItemTemplate>
                                    <asp:Label ID = "LabelInstrumentName" runat = "server" Text = '<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Name"))) %>'/>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField FooterStyle-HorizontalAlign="Left" AccessibleHeaderText = "Select">
                                <ItemTemplate>
                                   <asp:Button ID="ButtonSelect" runat="server"
                                        Text="Select"  
                                        ToolTip='<%# "Select to submit " + AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Name"))) %>' 
                                        CommandName="SELECT" 
                                        CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Id"))) %>' 
                                        CausesValidation="false"
                                        OnClientClick="javascript:if(Page_ClientValidate())return aspnetForm.target ='_self';"
                                       />
                                </ItemTemplate>
                            </asp:TemplateField>

                        </Columns>
                    </asp:GridView>
                </td>
            </tr>
        </table>   

                      
    </asp:Panel>
<br />
<br />
</asp:Content>

